/*
 * Lightcase - jQuery Plugin
 * The smart and flexible Lightbox Plugin.
 *
 * @author		Cornel Boppart <cornel@bopp-art.com>
 * @copyright	Author
 *
 * @version		2.5.0 (11/03/2018)
 */

(function(d){var a={cache:{},support:{},objects:{},init:function(b){return this.each(function(){d(this).unbind("click.lightcase").bind("click.lightcase",function(c){c.preventDefault();d(this).lightcase("start",b)})})},start:function(b){a.origin=lightcase.origin=this;a.settings=lightcase.settings=d.extend(!0,{idPrefix:"lightcase-",classPrefix:"lightcase-",attrPrefix:"lc-",transition:"elastic",transitionOpen:null,transitionClose:null,transitionIn:null,transitionOut:null,cssTransitions:!0,speedIn:250,
speedOut:250,width:null,height:null,maxWidth:800,maxHeight:500,forceWidth:!1,forceHeight:!1,liveResize:!0,fullScreenModeForMobile:!0,mobileMatchExpression:/(iphone|ipod|ipad|android|blackberry|symbian)/,disableShrink:!1,fixedRatio:!0,shrinkFactor:.75,overlayOpacity:.9,slideshow:!1,slideshowAutoStart:!0,breakBeforeShow:!1,timeout:5E3,swipe:!0,useKeys:!0,useCategories:!0,useAsCollection:!1,navigateEndless:!0,closeOnOverlayClick:!0,title:null,caption:null,showTitle:!0,showCaption:!0,showSequenceInfo:!0,
inline:{width:"auto",height:"auto"},ajax:{width:"auto",height:"auto",type:"get",dataType:"html",data:{}},iframe:{width:800,height:500,frameborder:0},flash:{width:400,height:205,wmode:"transparent"},video:{width:400,height:225,poster:"",preload:"auto",controls:!0,autobuffer:!0,autoplay:!0,loop:!1},attr:"data-rel",href:null,type:null,typeMapping:{image:"jpg,jpeg,gif,png,bmp",flash:"swf",video:"mp4,mov,ogv,ogg,webm",iframe:"html,php",ajax:"json,txt",inline:"#"},errorMessage:function(){return'<p class="'+
a.settings.classPrefix+'error">'+a.settings.labels.errorMessage+"</p>"},labels:{errorMessage:"Source could not be found...","sequenceInfo.of":" of ",close:"Close","navigator.prev":"Prev","navigator.next":"Next","navigator.play":"Play","navigator.pause":"Pause"},markup:function(){a.objects.body.append(a.objects.overlay=d('<div id="'+a.settings.idPrefix+'overlay"></div>'),a.objects.loading=d('<div id="'+a.settings.idPrefix+'loading" class="'+a.settings.classPrefix+'icon-spin"></div>'),a.objects["case"]=
d('<div id="'+a.settings.idPrefix+'case" aria-hidden="true" role="dialog"></div>'));a.objects["case"].after(a.objects.close=d('<a href="#" class="'+a.settings.classPrefix+'icon-close"><span>'+a.settings.labels.close+"</span></a>"),a.objects.nav=d('<div id="'+a.settings.idPrefix+'nav"></div>'));a.objects.nav.append(a.objects.prev=d('<a href="#" class="'+a.settings.classPrefix+'icon-prev"><span>'+a.settings.labels["navigator.prev"]+"</span></a>").hide(),a.objects.next=d('<a href="#" class="'+a.settings.classPrefix+
'icon-next"><span>'+a.settings.labels["navigator.next"]+"</span></a>").hide(),a.objects.play=d('<a href="#" class="'+a.settings.classPrefix+'icon-play"><span>'+a.settings.labels["navigator.play"]+"</span></a>").hide(),a.objects.pause=d('<a href="#" class="'+a.settings.classPrefix+'icon-pause"><span>'+a.settings.labels["navigator.pause"]+"</span></a>").hide());a.objects["case"].append(a.objects.content=d('<div id="'+a.settings.idPrefix+'content"></div>'),a.objects.info=d('<div id="'+a.settings.idPrefix+
'info"></div>'));a.objects.content.append(a.objects.contentInner=d('<div class="'+a.settings.classPrefix+'contentInner"></div>'));a.objects.info.append(a.objects.sequenceInfo=d('<div id="'+a.settings.idPrefix+'sequenceInfo"></div>'),a.objects.title=d('<h4 id="'+a.settings.idPrefix+'title"></h4>'),a.objects.caption=d('<p id="'+a.settings.idPrefix+'caption"></p>'))},onInit:{},onStart:{},onBeforeCalculateDimensions:{},onAfterCalculateDimensions:{},onBeforeShow:{},onFinish:{},onResize:{},onClose:{},onCleanup:{}},
b,a.origin.data?a.origin.data("lc-options"):{});a.objects.document=d("html");a.objects.body=d("body");a._callHooks(a.settings.onInit);a.objectData=a._setObjectData(this);a._addElements();a._open();a.dimensions=a.getViewportDimensions()},get:function(b){return a.objects[b]},getObjectData:function(){return a.objectData},_setObjectData:function(b){var c=d(b);b={"this":d(b),title:a.settings.title||c.attr(a._prefixAttributeName("title"))||c.attr("title"),caption:a.settings.caption||c.attr(a._prefixAttributeName("caption"))||
c.children("img").attr("alt"),url:a._determineUrl(),requestType:a.settings.ajax.type,requestData:a.settings.ajax.data,requestDataType:a.settings.ajax.dataType,rel:c.attr(a._determineAttributeSelector()),type:a.settings.type||a._verifyDataType(a._determineUrl()),isPartOfSequence:a.settings.useAsCollection||a._isPartOfSequence(c.attr(a.settings.attr),":"),isPartOfSequenceWithSlideshow:a._isPartOfSequence(c.attr(a.settings.attr),":slideshow"),currentIndex:d(a._determineAttributeSelector()).index(c),
sequenceLength:d(a._determineAttributeSelector()).length};b.sequenceInfo=b.currentIndex+1+a.settings.labels["sequenceInfo.of"]+b.sequenceLength;b.prevIndex=b.currentIndex-1;b.nextIndex=b.currentIndex+1;return b},_prefixAttributeName:function(b){return"data-"+a.settings.attrPrefix+b},_determineLinkTarget:function(){return a.settings.href||d(a.origin).attr(a._prefixAttributeName("href"))||d(a.origin).attr("href")},_determineAttributeSelector:function(){var b=d(a.origin),c="";"undefined"!==typeof a.cache.selector?
c=a.cache.selector:!0===a.settings.useCategories&&b.attr(a._prefixAttributeName("categories"))?(b=b.attr(a._prefixAttributeName("categories")).split(" "),d.each(b,function(e,g){0<e&&(c+=",");c+="["+a._prefixAttributeName("categories")+'~="'+g+'"]'})):c="["+a.settings.attr+'="'+b.attr(a.settings.attr)+'"]';return a.cache.selector=c},_determineUrl:function(){var b=a._verifyDataUrl(a._determineLinkTarget()),c=0,e=0,g="",f;d.each(b,function(l,h){switch(a._verifyDataType(h.url)){case "video":var k=document.createElement("video"),
m=a._verifyDataType(h.url)+"/"+a._getFileUrlSuffix(h.url);"probably"!==g&&g!==k.canPlayType(m)&&""!==k.canPlayType(m)&&(g=k.canPlayType(m),f=h.url);break;default:a._devicePixelRatio()>=h.density&&h.density>=e&&a._matchMedia()("screen and (min-width:"+h.width+"px)").matches&&h.width>=c&&(c=h.width,e=h.density,f=h.url)}});return f},_normalizeUrl:function(b){var c=/^\d+$/;return b.split(",").map(function(e){var g={width:0,density:0};e.trim().split(/\s+/).forEach(function(f,l){if(0===l)return g.url=f;
var h=f.substring(0,f.length-1),k=f[f.length-1],m=parseInt(h,10),n=parseFloat(h);"w"===k&&c.test(h)?g.width=m:"h"===k&&c.test(h)?g.height=m:"x"!==k||isNaN(n)||(g.density=n)});return g})},_isPartOfSequence:function(b,c){var e=d("["+a.settings.attr+'="'+b+'"]');return(new RegExp(c)).test(b)&&1<e.length},isSlideshowEnabled:function(){return a.objectData.isPartOfSequence&&(!0===a.settings.slideshow||!0===a.objectData.isPartOfSequenceWithSlideshow)},_loadContent:function(){a.cache.originalObject&&a._restoreObject();
a._createObject()},_createObject:function(){switch(a.objectData.type){case "image":var b=d(new Image);b.attr({src:a.objectData.url,alt:a.objectData.title});break;case "inline":b=d('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');b.html(a._cloneObject(d(a.objectData.url)));d.each(a.settings.inline,function(c,e){b.attr(a._prefixAttributeName(c),e)});break;case "ajax":b=d('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');d.each(a.settings.ajax,function(c,e){"data"!==c&&b.attr(a._prefixAttributeName(c),
e)});break;case "flash":b=d('<embed src="'+a.objectData.url+'" type="application/x-shockwave-flash"></embed>');d.each(a.settings.flash,function(c,e){b.attr(c,e)});break;case "video":b=d("<video></video>");b.attr("src",a.objectData.url);d.each(a.settings.video,function(c,e){b.attr(c,e)});break;default:b=d("<iframe></iframe>"),b.attr({src:a.objectData.url}),d.each(a.settings.iframe,function(c,e){b.attr(c,e)})}a._addObject(b);a._loadObject(b)},_addObject:function(b){a.objects.contentInner.html(b);a._loading("start");
a._callHooks(a.settings.onStart);!0===a.settings.showSequenceInfo&&a.objectData.isPartOfSequence?(a.objects.sequenceInfo.html(a.objectData.sequenceInfo),a.objects.sequenceInfo.show()):(a.objects.sequenceInfo.empty(),a.objects.sequenceInfo.hide());!0===a.settings.showTitle&&void 0!==a.objectData.title&&""!==a.objectData.title?(a.objects.title.html(a.objectData.title),a.objects.title.show()):(a.objects.title.empty(),a.objects.title.hide());!0===a.settings.showCaption&&void 0!==a.objectData.caption&&
""!==a.objectData.caption?(a.objects.caption.html(a.objectData.caption),a.objects.caption.show()):(a.objects.caption.empty(),a.objects.caption.hide())},_loadObject:function(b){switch(a.objectData.type){case "inline":d(a.objectData.url)?a._showContent(b):a.error();break;case "ajax":d.ajax(d.extend({},a.settings.ajax,{url:a.objectData.url,type:a.objectData.requestType,dataType:a.objectData.requestDataType,data:a.objectData.requestData,success:function(c,e,g){g.getResponseHeader("X-Ajax-Location")?(a.objectData.url=
g.getResponseHeader("X-Ajax-Location"),a._loadObject(b)):("json"===a.objectData.requestDataType?a.objectData.data=c:b.html(c),a._showContent(b))},error:function(c,e,g){a.error()}}));break;case "flash":a._showContent(b);break;case "video":"function"===typeof b.get(0).canPlayType||0===a.objects["case"].find("video").length?a._showContent(b):a.error();break;default:a.objectData.url?(b.on("load",function(){a._showContent(b)}),b.on("error",function(){a.error()})):a.error()}},error:function(){a.objectData.type=
"error";var b=d('<div class="'+a.settings.classPrefix+'inlineWrap"></div>');b.html(a.settings.errorMessage);a.objects.contentInner.html(b);a._showContent(a.objects.contentInner)},_calculateDimensions:function(b){a._cleanupDimensions();if(b){var c={ratio:1,objectWidth:b.attr("width")?b.attr("width"):b.attr(a._prefixAttributeName("width")),objectHeight:b.attr("height")?b.attr("height"):b.attr(a._prefixAttributeName("height"))};if(!a.settings.disableShrink)switch(c.maxWidth=parseInt(a.dimensions.windowWidth*
a.settings.shrinkFactor),c.maxHeight=parseInt(a.dimensions.windowHeight*a.settings.shrinkFactor),c.maxWidth>a.settings.maxWidth&&(c.maxWidth=a.settings.maxWidth),c.maxHeight>a.settings.maxHeight&&(c.maxHeight=a.settings.maxHeight),c.differenceWidthAsPercent=parseInt(100/c.maxWidth*c.objectWidth),c.differenceHeightAsPercent=parseInt(100/c.maxHeight*c.objectHeight),a.objectData.type){case "image":case "flash":case "video":case "iframe":case "ajax":case "inline":if("image"===a.objectData.type||!0===
a.settings.fixedRatio){100<c.differenceWidthAsPercent&&c.differenceWidthAsPercent>c.differenceHeightAsPercent&&(c.objectWidth=c.maxWidth,c.objectHeight=parseInt(c.objectHeight/c.differenceWidthAsPercent*100));100<c.differenceHeightAsPercent&&c.differenceHeightAsPercent>c.differenceWidthAsPercent&&(c.objectWidth=parseInt(c.objectWidth/c.differenceHeightAsPercent*100),c.objectHeight=c.maxHeight);100<c.differenceHeightAsPercent&&c.differenceWidthAsPercent<c.differenceHeightAsPercent&&(c.objectWidth=
parseInt(c.maxWidth/c.differenceHeightAsPercent*c.differenceWidthAsPercent),c.objectHeight=c.maxHeight);break}case "error":!isNaN(c.objectWidth)&&c.objectWidth>c.maxWidth&&(c.objectWidth=c.maxWidth);break;default:(isNaN(c.objectWidth)||c.objectWidth>c.maxWidth)&&!a.settings.forceWidth&&(c.objectWidth=c.maxWidth),(isNaN(c.objectHeight)&&"auto"!==c.objectHeight||c.objectHeight>c.maxHeight)&&!a.settings.forceHeight&&(c.objectHeight=c.maxHeight)}if(a.settings.forceWidth){try{c.objectWidth=a.settings[a.objectData.type].width}catch(e){c.objectWidth=
a.settings.width||c.objectWidth}c.maxWidth=null}b.attr(a._prefixAttributeName("max-width"))&&(c.maxWidth=b.attr(a._prefixAttributeName("max-width")));if(a.settings.forceHeight){try{c.objectHeight=a.settings[a.objectData.type].height}catch(e){c.objectHeight=a.settings.height||c.objectHeight}c.maxHeight=null}b.attr(a._prefixAttributeName("max-height"))&&(c.maxHeight=b.attr(a._prefixAttributeName("max-height")));a._adjustDimensions(b,c)}},_adjustDimensions:function(b,c){b.css({width:c.objectWidth,height:c.objectHeight,
"max-width":c.maxWidth,"max-height":c.maxHeight});a.objects.contentInner.css({width:b.outerWidth(),height:b.outerHeight(),"max-width":"100%"});a.objects["case"].css({width:a.objects.contentInner.outerWidth(),"max-width":"100%"});a.objects["case"].css({"margin-top":parseInt(-(a.objects["case"].outerHeight()/2)),"margin-left":parseInt(-(a.objects["case"].outerWidth()/2))})},_loading:function(b){"start"===b?(a.objects["case"].addClass(a.settings.classPrefix+"loading"),a.objects.loading.show()):"end"===
b&&(a.objects["case"].removeClass(a.settings.classPrefix+"loading"),a.objects.loading.hide())},getViewportDimensions:function(){return{windowWidth:d(window).innerWidth(),windowHeight:d(window).innerHeight()}},_verifyDataUrl:function(b){if(!b||void 0===b||""===b)return!1;-1<b.indexOf("#")&&(b=b.split("#"),b="#"+b[b.length-1]);return a._normalizeUrl(b.toString())},_getFileUrlSuffix:function(b){return/(?:\.([^.]+))?$/.exec(b.toLowerCase())[1]},_verifyDataType:function(b){var c=a.settings.typeMapping;
if(!b)return!1;for(var e in c)if(c.hasOwnProperty(e))for(var g=c[e].split(","),f=0;f<g.length;f++){var l=g[f].toLowerCase(),h=new RegExp(".("+l+")$","i"),k=b.toLowerCase().split("?")[0].substr(-5);if(!0===h.test(k)||"inline"===e&&-1<b.indexOf(l))return e}return"iframe"},_addElements:function(){"undefined"!==typeof a.objects["case"]&&d("#"+a.objects["case"].attr("id")).length||a.settings.markup()},_showContent:function(b){a.objects.document.attr(a._prefixAttributeName("type"),a.objectData.type);a.cache.object=
b;a._callHooks(a.settings.onBeforeShow);a.settings.breakBeforeShow||a.show()},_startInTransition:function(){switch(a.transition["in"]()){case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollHorizontal":case "scrollVertical":a.transition.scroll(a.objects["case"],"in",a.settings.speedIn);a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn);break;case "elastic":1>a.objects["case"].css("opacity")&&(a.transition.zoom(a.objects["case"],"in",a.settings.speedIn),
a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn));case "fade":case "fadeInline":a.transition.fade(a.objects["case"],"in",a.settings.speedIn);a.transition.fade(a.objects.contentInner,"in",a.settings.speedIn);break;default:a.transition.fade(a.objects["case"],"in",0)}a._loading("end");a.isBusy=!1;a.cache.firstOpened||(a.cache.firstOpened=a.objectData["this"]);a.objects.info.hide();setTimeout(function(){a.transition.fade(a.objects.info,"in",a.settings.speedIn)},a.settings.speedIn);a._callHooks(a.settings.onFinish)},
_processContent:function(){a.isBusy=!0;a.transition.fade(a.objects.info,"out",0);switch(a.settings.transitionOut){case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollVertical":case "scrollHorizontal":a.objects["case"].is(":hidden")?(a.transition.fade(a.objects.contentInner,"out",0),a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()})):a.transition.scroll(a.objects["case"],"out",a.settings.speedOut,function(){a._loadContent()});break;case "fade":a.objects["case"].is(":hidden")?
a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()}):a.transition.fade(a.objects["case"],"out",a.settings.speedOut,0,function(){a._loadContent()});break;case "fadeInline":case "elastic":a.objects["case"].is(":hidden")?a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()}):a.transition.fade(a.objects.contentInner,"out",a.settings.speedOut,0,function(){a._loadContent()});break;default:a.transition.fade(a.objects["case"],"out",0,0,function(){a._loadContent()})}},
_handleEvents:function(){a._unbindEvents();a.objects.nav.children().not(a.objects.close).hide();a.isSlideshowEnabled()&&(!0!==a.settings.slideshowAutoStart&&!a.isSlideshowStarted||a.objects.nav.hasClass(a.settings.classPrefix+"paused")?a._stopTimeout():a._startTimeout());a.settings.liveResize&&a._watchResizeInteraction();a.objects.close.click(function(b){b.preventDefault();a.close()});!0===a.settings.closeOnOverlayClick&&a.objects.overlay.css("cursor","pointer").click(function(b){b.preventDefault();
a.close()});!0===a.settings.useKeys&&a._addKeyEvents();if(a.objectData.isPartOfSequence&&(a.objects.nav.attr(a._prefixAttributeName("ispartofsequence"),!0),a.objects.nav.data("items",a._setNavigation()),a.objects.prev.click(function(b){b.preventDefault();!0!==a.settings.navigateEndless&&a.item.isFirst()||(a.objects.prev.unbind("click"),a.cache.action="prev",a.objects.nav.data("items").prev.click(),a.isSlideshowEnabled()&&a._stopTimeout())}),a.objects.next.click(function(b){b.preventDefault();!0!==
a.settings.navigateEndless&&a.item.isLast()||(a.objects.next.unbind("click"),a.cache.action="next",a.objects.nav.data("items").next.click(),a.isSlideshowEnabled()&&a._stopTimeout())}),a.isSlideshowEnabled()&&(a.objects.play.click(function(b){b.preventDefault();a._startTimeout()}),a.objects.pause.click(function(b){b.preventDefault();a._stopTimeout()})),!0===a.settings.swipe)){if(d.isPlainObject(d.event.special.swipeleft))a.objects["case"].on("swipeleft",function(b){b.preventDefault();a.objects.next.click();
a.isSlideshowEnabled()&&a._stopTimeout()});if(d.isPlainObject(d.event.special.swiperight))a.objects["case"].on("swiperight",function(b){b.preventDefault();a.objects.prev.click();a.isSlideshowEnabled()&&a._stopTimeout()})}},_addKeyEvents:function(){d(document).bind("keyup.lightcase",function(b){if(!a.isBusy)switch(b.keyCode){case 27:a.objects.close.click();break;case 37:a.objectData.isPartOfSequence&&a.objects.prev.click();break;case 39:a.objectData.isPartOfSequence&&a.objects.next.click()}})},_startTimeout:function(){a.isSlideshowStarted=
!0;a.objects.play.hide();a.objects.pause.show();a.cache.action="next";a.objects.nav.removeClass(a.settings.classPrefix+"paused");a.timeout=setTimeout(function(){a.objects.nav.data("items").next.click()},a.settings.timeout)},_stopTimeout:function(){a.objects.play.show();a.objects.pause.hide();a.objects.nav.addClass(a.settings.classPrefix+"paused");clearTimeout(a.timeout)},_setNavigation:function(){var b=d(a.cache.selector||a.settings.attr),c=a.objectData.sequenceLength-1,e={prev:b.eq(a.objectData.prevIndex),
next:b.eq(a.objectData.nextIndex)};0<a.objectData.currentIndex?a.objects.prev.show():e.prevItem=b.eq(c);a.objectData.nextIndex<=c?a.objects.next.show():e.next=b.eq(0);!0===a.settings.navigateEndless&&(a.objects.prev.show(),a.objects.next.show());return e},item:{isFirst:function(){return 0===a.objectData.currentIndex},isFirstOpened:function(){return a.objectData["this"].is(a.cache.firstOpened)},isLast:function(){return a.objectData.currentIndex===a.objectData.sequenceLength-1}},_cloneObject:function(b){var c=
b.clone(),e=b.attr("id");b.is(":hidden")?(a._cacheObjectData(b),b.attr("id",a.settings.idPrefix+"temp-"+e).empty()):c.removeAttr("id");return c.show()},isMobileDevice:function(){return navigator.userAgent.toLowerCase().match(a.settings.mobileMatchExpression)?!0:!1},isTransitionSupported:function(){var b=a.objects.body.get(0),c=!1,e={transition:"",WebkitTransition:"-webkit-",MozTransition:"-moz-",OTransition:"-o-",MsTransition:"-ms-"},g;for(g in e)e.hasOwnProperty(g)&&g in b.style&&(a.support.transition=
e[g],c=!0);return c},transition:{"in":function(){return a.settings.transitionOpen&&!a.cache.firstOpened?a.settings.transitionOpen:a.settings.transitionIn},fade:function(b,c,e,g,f){var l="in"===c;c={};var h=b.css("opacity"),k={};if(a.isOpen||!l)c.opacity=h,k.opacity=g?g:l?1:0,b.css(a.support.transition+"transition","none"),b.css(c).show(),a.support.transitions?(k[a.support.transition+"transition"]=e+"ms ease",setTimeout(function(){b.css(k);setTimeout(function(){b.css(a.support.transition+"transition",
"");!f||!a.isOpen&&l||f()},e)},15)):(b.stop(),b.animate(k,e,f))},scroll:function(b,c,e,g){var f="in"===c;c=f?a.settings.transitionIn:a.settings.transitionOut;var l="left",h={},k=f?"-50%":"50%",m={},n=f?"50%":"-50%";if(a.isOpen||!f){switch(c){case "scrollTop":l="top";break;case "scrollRight":k=f?"150%":"50%";n=f?"50%":"150%";break;case "scrollBottom":l="top";k=f?"150%":"50%";n=f?"50%":"150%";break;case "scrollHorizontal":k=f?"150%":"50%";n=f?"50%":"-50%";break;case "scrollVertical":l="top",k=f?"-50%":
"50%",n=f?"50%":"150%"}if("prev"===a.cache.action)switch(c){case "scrollHorizontal":k=f?"-50%":"50%";n=f?"50%":"150%";break;case "scrollVertical":k=f?"150%":"50%",n=f?"50%":"-50%"}h.opacity=f?0:1;h[l]=k;m.opacity=f?1:0;m[l]=n;b.css(a.support.transition+"transition","none");b.css(h).show();a.support.transitions?(m[a.support.transition+"transition"]=e+"ms ease",setTimeout(function(){b.css(m);setTimeout(function(){b.css(a.support.transition+"transition","");!g||!a.isOpen&&f||g()},e)},15)):(b.stop(),
b.animate(m,e,g))}},zoom:function(b,c,e,g){var f="in"===c;c={};var l=b.css("opacity"),h={},k=f?"scale(1)":"scale(0.75)";if(a.isOpen||!f)c.opacity=l,c[a.support.transition+"transform"]=f?"scale(0.75)":"scale(1)",h.opacity=f?1:0,b.css(a.support.transition+"transition","none"),b.css(c).show(),a.support.transitions?(h[a.support.transition+"transform"]=k,h[a.support.transition+"transition"]=e+"ms ease",setTimeout(function(){b.css(h);setTimeout(function(){b.css(a.support.transition+"transform","");b.css(a.support.transition+
"transition","");!g||!a.isOpen&&f||g()},e)},15)):(b.stop(),b.animate(h,e,g))}},_callHooks:function(b){"object"===typeof b&&d.each(b,function(c,e){"function"===typeof e&&e.call(a.origin)})},_cacheObjectData:function(b){d.data(b,"cache",{id:b.attr("id"),content:b.html()});a.cache.originalObject=b},_restoreObject:function(){var b=d('[id^="'+a.settings.idPrefix+'temp-"]');b.attr("id",d.data(a.cache.originalObject,"cache").id);b.html(d.data(a.cache.originalObject,"cache").content)},resize:function(b,c){a.isOpen&&
(a.isSlideshowEnabled()&&a._stopTimeout(),"object"===typeof c&&null!==c&&(c.width&&a.cache.object.attr(a._prefixAttributeName("width"),c.width),c.maxWidth&&a.cache.object.attr(a._prefixAttributeName("max-width"),c.maxWidth),c.height&&a.cache.object.attr(a._prefixAttributeName("height"),c.height),c.maxHeight&&a.cache.object.attr(a._prefixAttributeName("max-height"),c.maxHeight)),a.dimensions=a.getViewportDimensions(),a._calculateDimensions(a.cache.object),a._callHooks(a.settings.onResize))},_watchResizeInteraction:function(){d(window).resize(a.resize)},
_unwatchResizeInteraction:function(){d(window).off("resize",a.resize)},_switchToFullScreenMode:function(){a.settings.shrinkFactor=1;a.settings.overlayOpacity=1;d("html").addClass(a.settings.classPrefix+"fullScreenMode")},_open:function(){a.isOpen=!0;a.support.transitions=a.settings.cssTransitions?a.isTransitionSupported():!1;a.support.mobileDevice=a.isMobileDevice();a.support.mobileDevice&&(d("html").addClass(a.settings.classPrefix+"isMobileDevice"),a.settings.fullScreenModeForMobile&&a._switchToFullScreenMode());
a.settings.transitionIn||(a.settings.transitionIn=a.settings.transition);a.settings.transitionOut||(a.settings.transitionOut=a.settings.transition);switch(a.transition["in"]()){case "fade":case "fadeInline":case "elastic":case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollVertical":case "scrollHorizontal":a.objects["case"].is(":hidden")&&(a.objects.close.css("opacity",0),a.objects.overlay.css("opacity",0),a.objects["case"].css("opacity",0),a.objects.contentInner.css("opacity",
0));a.transition.fade(a.objects.overlay,"in",a.settings.speedIn,a.settings.overlayOpacity,function(){a.transition.fade(a.objects.close,"in",a.settings.speedIn);a._handleEvents();a._processContent()});break;default:a.transition.fade(a.objects.overlay,"in",0,a.settings.overlayOpacity,function(){a.transition.fade(a.objects.close,"in",0);a._handleEvents();a._processContent()})}a.objects.document.addClass(a.settings.classPrefix+"open");a.objects["case"].attr("aria-hidden","false")},show:function(){a._callHooks(a.settings.onBeforeCalculateDimensions);
a._calculateDimensions(a.cache.object);a._callHooks(a.settings.onAfterCalculateDimensions);a._startInTransition()},close:function(){a.isOpen=!1;a.isSlideshowEnabled()&&(a._stopTimeout(),a.isSlideshowStarted=!1,a.objects.nav.removeClass(a.settings.classPrefix+"paused"));a.objects.loading.hide();a._unbindEvents();a._unwatchResizeInteraction();d("html").removeClass(a.settings.classPrefix+"open");a.objects["case"].attr("aria-hidden","true");a.objects.nav.children().hide();a.objects.close.hide();a._callHooks(a.settings.onClose);
a.transition.fade(a.objects.info,"out",0);switch(a.settings.transitionClose||a.settings.transitionOut){case "fade":case "fadeInline":case "scrollTop":case "scrollRight":case "scrollBottom":case "scrollLeft":case "scrollHorizontal":case "scrollVertical":a.transition.fade(a.objects["case"],"out",a.settings.speedOut,0,function(){a.transition.fade(a.objects.overlay,"out",a.settings.speedOut,0,function(){a.cleanup()})});break;case "elastic":a.transition.zoom(a.objects["case"],"out",a.settings.speedOut,
function(){a.transition.fade(a.objects.overlay,"out",a.settings.speedOut,0,function(){a.cleanup()})});break;default:a.cleanup()}},_unbindEvents:function(){a.objects.overlay.unbind("click");d(document).unbind("keyup.lightcase");a.objects["case"].unbind("swipeleft").unbind("swiperight");a.objects.prev.unbind("click");a.objects.next.unbind("click");a.objects.play.unbind("click");a.objects.pause.unbind("click");a.objects.close.unbind("click")},_cleanupDimensions:function(){var b=a.objects.contentInner.css("opacity");
a.objects["case"].css({width:"",height:"",top:"",left:"","margin-top":"","margin-left":""});a.objects.contentInner.removeAttr("style").css("opacity",b);a.objects.contentInner.children().removeAttr("style")},cleanup:function(){a._cleanupDimensions();a.objects.loading.hide();a.objects.overlay.hide();a.objects["case"].hide();a.objects.prev.hide();a.objects.next.hide();a.objects.play.hide();a.objects.pause.hide();a.objects.document.removeAttr(a._prefixAttributeName("type"));a.objects.nav.removeAttr(a._prefixAttributeName("ispartofsequence"));
a.objects.contentInner.empty().hide();a.objects.info.children().empty();a.cache.originalObject&&a._restoreObject();a._callHooks(a.settings.onCleanup);a.cache={}},_matchMedia:function(){return window.matchMedia||window.msMatchMedia},_devicePixelRatio:function(){return window.devicePixelRatio||1},_isPublicMethod:function(b){return"function"===typeof a[b]&&"_"!==b.charAt(0)},_export:function(){window.lightcase={};d.each(a,function(b){a._isPublicMethod(b)&&(lightcase[b]=a[b])})}};a._export();d.fn.lightcase=
function(b){if(a._isPublicMethod(b))return a[b].apply(this,Array.prototype.slice.call(arguments,1));if("object"!==typeof b&&b)d.error("Method "+b+" does not exist on jQuery.lightcase");else return a.init.apply(this,arguments)}})(jQuery);