<?php

/////////////////////////////////////
////// PAGINATION ///////////////////
/////////////////////////////////////

function gg_pagination() {
    include_once(GG_DIR . '/classes/gg_overlay_manager.php');

    /* SC structure
    'gid' 			=> '',
    'overlay' 		=> 'default',

    'filter' 	 => '',
    'search_str' => '',
    'page'		 => 0,
    */

    
    // default shortcode atts
    if(!isset($_POST['gid']) || !filter_var($_POST['gid'], FILTER_VALIDATE_INT)) {
        wp_die('Gallery ID is missing');
    }
    if(!isset($_POST['gg_pag_vars'])) {
        wp_die('Missing gallery pag vars');
    }
    if(!isset($_POST['gg_page'])) {
        wp_die('wrong page number');
    }
    
    
    $_POST['gg_pag_vars'] = json_decode(stripslashes($_POST['gg_pag_vars']), true);
    
    $sc_atts = array();
    $sc_atts['gid'] = (int)$_POST['gid'];
    $sc_atts['overlay']	= (!isset($_POST['gg_ol'])) ? 'default' : $_POST['gg_ol'];


    //// ajax-related shortcode atts
    // is applying a filter? handle matching image indexes
    $sc_atts['filter'] = '';
    if(isset($_POST['gg_filtered_imgs']) && !empty($_POST['gg_filtered_imgs'])) {
        $sc_atts['filter'] = implode(',', json_decode(stripslashes($_POST['gg_filtered_imgs']), true));
    }
    
    // is searching?
    $sc_atts['search_str'] = (isset($_POST['gg_search_str'])) ? $_POST['gg_search_str'] : '';

    // page
    $sc_atts['page'] = (is_array($_POST['gg_page'])) ? $_POST['gg_page'] : (int)$_POST['gg_page'];


    // wrap up atts in a final array 
    $atts = array();
    foreach($sc_atts as $key => $val) {
        $atts[] = $key .'="'. esc_attr($val) .'"';	
    }
    
    $GLOBALS['gg_gallery_is_ajax_mode'] = true;
    $sc = '[g-gallery '. implode(' ', $atts) .']'; 
    wp_die(
        do_shortcode($sc)
    );
}
add_action('wp_ajax_gg_pagination', 'gg_pagination');
add_action('wp_ajax_nopriv_gg_pagination', 'gg_pagination');





//////////////////////////////////////////////////////////////////////////////





////////////////////////////////////////////
////// LOAD GALLERY WITHIN COLLECTION //////
////////////////////////////////////////////

function gg_load_coll_gallery() {
    if(!isset($_POST['gdata'])) {
        wp_die('data is missing');
    }
    $gdata = json_decode(base64_decode($_POST['gdata']), true);

    wp_die(
        do_shortcode('[g-gallery gid="'.$gdata['id'].'" random="'.$gdata['rand'].'" filters="'.$gdata['filters'].'" search="'.$gdata['search'].'" watermark="'.$gdata['wmark'].'"]')
    );
}
add_action('wp_ajax_gg_load_coll_gallery', 'gg_load_coll_gallery');
add_action('wp_ajax_nopriv_gg_load_coll_gallery', 'gg_load_coll_gallery');

