<?php
// REGISTER BLOCK
include_once(GG_DIR .'/settings/field_options.php');


// structure
$defaults = array(
	'gid' => array(
		'label'		=> __('Which gallery?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => __('Select a gallery', 'gg_ml')) + $GLOBALS['gg_guten_galls'],
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'width' => array(
		'label'		=> __('Box width', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 100,
		'panel'		=> 'main',
	),
	'w_type' => array(
		'label'		=> __('Width unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'img_h' => array(
		'label'		=> __('Images height', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 20,
		'max'		=> 1000,
		'default' 	=> 75,
		'panel'		=> 'main',
	),
	'h_type' => array(
		'label'		=> __('Height unit type', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'px'	=> 'px (static)',
			'%'		=> '% (responsive)',
		),
		'default' 	=> '%',
		'panel'		=> 'main',
	),
	'layout' => array(
		'label'		=> __('Layout', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => __('(as default)', 'gg_ml')) + gg_itg_layouts(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'img_num' => array(
		'label'		=> __('How many images to display?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'1'	=> 1,
			'2'	=> 2,
			'4'	=> 4,
		),
		'default' 	=> '1',
		'panel'		=> 'main',
	),
	'font_size' => array(
		'label'		=> __("Custom font size", 'gg_ml') .' (rem)',
		'help'		=> __('Leave empty to use default one', 'gg_ml'),
		'type'		=> 'text',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> __('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'watermark' => array(
		'label'		=> __('Use watermark?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'ol_txt' => array(
		'label'		=> __("Custom overlay text", 'gg_ml'),
		'help'		=> __('Remember you can use placeholders and FontAwesome icons as explained in settings', 'gg_ml'),
		'type'		=> 'textarea',
		'default' 	=> '',
		'panel'		=> 'main',
	),
);





$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-itg', array(
	'editor_script' 	=> 'gg_itg_on_guten',
	'render_callback' 	=> 'gg_itg_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_itg_defaults', $defaults);
