<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class gg_gallery_divi_module extends ET_Builder_Module {

	public $slug       = 'gg_gallery';
	public $vb_support = 'on';

    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/global-gallery',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'GG - '. esc_html__('Gallery', 'gg_ml');
		$this->icon_path          =  $GLOBALS['gg_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main' => esc_html__('Main Options', 'gg_ml'),
					'styling'      => esc_html__('Styling', 'gg_ml'),
				),
			),
		);
	}
 
    
	public function get_fields() {
        include_once(GG_DIR .'/settings/field_options.php');
        
        $fields =array(
            'gid' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Images source', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys($GLOBALS['gg_divi_galls'])),
				'default_on_front'=> current(array_keys($GLOBALS['gg_divi_galls'])),
				'options'         => $GLOBALS['gg_divi_galls'],
				//'description'     => esc_html__( 'Choose whether your linklink opens in a new window or not', 'dicm-divi-custom-modules' ),
			),
            'random' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Random display?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'watermark' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Use watermark?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'filters' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Use tags filter?", 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),
            'search' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Enable search?", 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),
            'pagination' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Pagination system", 'gg_ml'),
				'type'            => 'select',
				'default'         => '',
				'default_on_front'=> '',					
				'options'         => array(
				    'unset' => __('Auto - follow global settings', 'gg_ml')
			     ) + gg_pag_sys(),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return gg_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new gg_gallery_divi_module;
