
<?php
	add_filter(
		'theme_mod_seo_video_title',
		function( $value ) {
			$video_title = get_the_title();
			$value      = str_replace( '%%video_title%%', $video_title, $value );
			return $value;
		}
	);
	add_filter(
		'theme_mod_seo_video_tracking_button',
		function( $value ) {
			$video_title = get_the_title();
			$value      = str_replace( '%%video_title%%', $video_title, $value );
			return $value;
		}
	);
	$video_title        = get_the_title();
	$video_tracking_url = get_post_meta($post->ID, 'tracking_url', true);
	if ( has_post_thumbnail() ) {
		$video_thumb_url = get_the_post_thumbnail_url(get_the_id(), 'video-thumb');
	}else{
		$video_thumb_url = get_post_meta( get_the_ID(), 'thumb', true );
	}



; ?>


<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> ">
	<section class="single-video-player">
		<div class="container">
			<div class="video-title">
				<h1><?php echo get_theme_mod( 'seo_video_title', $video_title ); ?></h1>
			</div>
			<div class="video-cat-tag2">
				<?php $postcats = get_the_category(); ?>
				<?php if( !empty($postcats) ) : ?>
					<?php foreach($postcats as $cat) {
						$cat_list[] = '<a class="btn btn-black" href="' . get_category_link( $cat->term_id ) . '" title="' . $cat->name . '">' . $cat->name . ' <span class="cat1">' . $cat->count . '</span></a>';
					} echo implode( '', $cat_list ); ?>
				<?php endif; ?>
				<?php $actors = wp_get_post_terms($post->ID, "actors"); ?>
				<?php if( !empty($actors) ) : ?>
					<?php foreach($actors as $actor) {
						$actor_list[] = '<a class="btn btn-primary" href="' . get_term_link($actor->term_id) . '" title="' . $actor->name . '">' . $actor->name . '</a>';
					} echo implode( ' ', $actor_list ); ?>
				<?php endif; ?>
			<?php $posttags = get_the_tags(); ?>
				<?php if( !empty($posttags) ) : ?>
					<?php foreach($posttags as $tag) {
						$tag_list[] = '<a class="btn btn-grey" href="' . get_tag_link( $tag->term_id ) . '" title="' . $tag->name . '">' . $tag->name . '</a>';
					} echo implode(' ', $tag_list ); ?>
				<?php endif; ?>
			</div>
			
			<div class="d-flex justify-content-between">
				<div class="video-left">
				    	
						<div class="video-actions-header">
								<?php the_content(); ?>
							<div id="video-views"><span class="views-number"></span> <?php esc_html_e('views', 'wpst'); ?></div>
						</div>

			
			
			<?php
				$related = get_posts( array(
					'category__in' => wp_get_post_categories($post->ID),
					// 'numberposts' => xbox_get_field_value( 'vtt-options', 'related-videos-number' ),
					'numberposts' => '10',
					'post__not_in' => array($post->ID),
					'orderby' => 'rand',
					'order'    => 'ASC',
					)
				);
				if ( $related ) :
			?>
			<div class="related-videos">
				<div class="row no-gutters">
					<?php
						foreach( $related as $post ) {
							setup_postdata($post);
							get_template_part( 'loop-templates/loop', 'video' );
						}
					?>
				</div>
			</div>
			<?php wp_reset_postdata(); endif; ?>
		</div>
	</section>
</article>


<?php // endwhile; endif; ?>
