<?php
add_action( 'xbox_init', 'vtt_video_information_metabox' );
function vtt_video_information_metabox() {
	$options = array(
		'id'            => 'video-information-metabox',
		'title'         => wp_get_theme()->get( 'Name' ) . ' - ' . esc_html__( 'Video information', 'wpst' ),
		'post_types'    => array( 'post' ),
		'layout'        => 'wide', // boxed
		'skin'          => 'pink',
		'fields_prefix' => '',
		'header'        => array(),
	);

	$xbox = xbox_new_metabox( $options );
	
	
	/* Views */
	$xbox->add_field(
		array(
			'id'         => 'post_views_count',
			'name'       => esc_html__( 'Views', 'wpst' ),
			'type'       => 'number',
			'options'    => array(
				'unit'            => 'views',
				'show_unit'       => true,
				'show_spinner'    => true,
				'disable_spinner' => false,
			),
			'attributes' => array(
				'min'       => 0,
				'step'      => 1,
				'precision' => 0,
			),
		)
	);



	/* Main thumb */
	$xbox->add_field(
		array(
			'id'      => 'thumb',
			'name'    => esc_html__( 'Main thumbnail', 'wpst' ),
			'type'    => 'file',
			'desc'    => esc_html__( 'Paste here the main thumb URL or upload an image file. If there isn\'t a featured image, this image will be used as main thumb.', 'wpst' ),
			'options' => array(
				'mime_types'   => array( 'jpg', 'jpeg', 'png', 'gif' ), // Default: array()
				'protocols'    => array( 'http', 'https' ), // Default: array()
				'preview_size' => array(
					'width'  => '320px',
					'height' => '200px',
				), // Default: array( 'width' => '64px', 'height' => 'auto' )
			),
		)
	);

	/* Thumbnail Rotation */
	$xbox->add_field(
		array(
			'id'   => 'thumbnails',
			'name' => esc_html__( 'Thumbnails', 'wpst' ),
			'type' => 'html',
			'desc' => esc_html__( 'Used for thumbnails rotation.', 'wpst' ),
		)
	);

}

/*
|---------------------------------------------------------------------------------------------------
| Inserting thumbnail in Ajax
|---------------------------------------------------------------------------------------------------
*/
function xbox_ajax_insert_thumb() {
	$nonce = $_POST['nonce'];
	if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) ) {
		die( 'Busted!' );
	}

	if ( isset( $_POST['current_url'], $_POST['thumb_url'] ) ) {
		$parts = parse_url( $_POST['current_url'] );
		parse_str( $parts['query'], $query );
		$post_id   = $query['post'];
		$thumb_url = $_POST['thumb_url'];
		add_post_meta( $post_id, 'thumbs', $thumb_url, false );
		$result = true;
	} else {
		$result = false;
	}

	wp_send_json( array( 'result' => $result ) );

	wp_die();
}
add_action( 'wp_ajax_xbox_ajax_insert_thumb', 'xbox_ajax_insert_thumb' );


/*
|---------------------------------------------------------------------------------------------------
| Removing thumbnail in Ajax
|---------------------------------------------------------------------------------------------------
*/
function xbox_ajax_remove_thumb() {
	$nonce = $_POST['nonce'];
	if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) ) {
		die( 'Busted!' );
	}

	if ( isset( $_POST['current_url'], $_POST['thumb_url'] ) ) {
		$parts = parse_url( $_POST['current_url'] );
		parse_str( $parts['query'], $query );
		$post_id   = $query['post'];
		$thumb_url = $_POST['thumb_url'];
		delete_post_meta( $post_id, 'thumbs', $thumb_url );
		$result = true;
	} else {
		$result = false;
	}

	wp_send_json( array( 'result' => $result ) );

	wp_die();
}
add_action( 'wp_ajax_xbox_ajax_remove_thumb', 'xbox_ajax_remove_thumb' );
