<?php
/**
 * Ajax Method to verify site.
 *
 * @api
 * @package admin\actions
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Verify site.
 *
 * @return void
 */
function wpscore_verify_site() {
	check_ajax_referer( 'ajax-nonce', 'nonce' );

	if ( ! isset( $_POST['verification_code'] ) ) {
		wp_die( 'parameter missing needed' );
	}

	$verification_code = sanitize_text_field( wp_unslash( $_POST['verification_code'] ) );

	$api_params = array(
		'core_version'      => WPSCORE_VERSION,
		'license_key'       => WPSCORE()->get_license_key(),
		'server_addr'       => WPSCORE()->get_server_addr(),
		'server_name'       => WPSCORE()->get_server_name(),
		'signature'         => WPSCORE()->get_client_signature(),
		'verification_code' => $verification_code,
		'site_key'          => WPSCORE()->get_option( 'site_key' ),
		'time'              => ceil( time() / 1000 ), // 100
	);

	$args = array(
		'timeout'   => 10,
		'sslverify' => false,
	);

	// PHPCS:ignore WordPress.PHP.DiscouragedPHPFunctions.serialize_serialize
	$base64_params = base64_encode( serialize( $api_params ) );

	// Send the request.
	$response = wp_remote_get( WPSCORE()->get_api_url( 'verify_site', $base64_params ), $args );

	if ( ! is_wp_error( $response ) && strpos( $response['headers']['content-type'], 'application/json' ) !== false ) {

		$response_body = json_decode( wp_remote_retrieve_body( $response ) );

		if ( 200 !== $response_body->data->status ) {

			WPSCORE()->write_log( 'error', 'Connection to API (verify_site) failed (status: <code>' . $response_body->data->status . '</code> message: <code>' . $response_body->message . '</code>)', __FILE__, __LINE__ );

		} else {
			if ( 'success' === $response_body->code ) {
				// WPSCORE()->update_product_status( $product_type, $product_sku, $response_body->data->product_status );
				WPSCORE()->write_log( 'success', 'Site verified', __FILE__, __LINE__ );
			} else {
				WPSCORE()->write_log( 'error', 'Connection to API (verify_site) failed (status: <code>' . $response_body->data->status . '</code> message: <code>' . $response_body->message . '</code>)', __FILE__, __LINE__ );
			}
		}
	} elseif ( is_wp_error( $response ) ) {
		WPSCORE()->write_log( 'error', $response->get_error_message() . ' <code>' . $response->get_error_code() . '</code>', WPSCORE_FILE, __LINE__ );
		wp_send_json(
			array(
				'body' => array(
					'code'    => 'error',
					'message' => $response->get_error_message() . ' <code>' . $response->get_error_code() . '</code>',
				),
			)
		);
	}

	wp_send_json( $response_body );

	wp_die();
}
add_action( 'wp_ajax_wpscore_verify_site', 'wpscore_verify_site' );
