<?php
// STATIC METHODS RELATED TO GALLERIES
class gg_gall_static {

    
    // gallery types
    public static function sources($type = false) {
        $types = array(
            'wp' 		=> esc_html__('Wordpress Library', 'gg_ml'),
            'wp_cat' 	=> esc_html__('Wordpress Category', 'gg_ml'),
            'cpt_tax' 	=> esc_html__('Custom post type Taxonomy', 'gg_ml'),
            'gg_album'	=> esc_html__('Global Gallery Album', 'gg_ml'),
            'picasa'	=> 'Google+ <strong class="gg_disc_source_label">(discontinued)</strong>',
            'flickr'	=> esc_html__('Flickr Album / Photostream / Tag URL', 'gg_ml'),
            'instagram'	=> 'Instagram <strong class="gg_disc_source_label">(discontinued)</strong>',
            'pinterest' => esc_html__('Pinterest Board', 'gg_ml'),
            'fb'		=> 'Facebook Page Album <strong class="gg_disc_source_label">(discontinued)</strong>',
            'g_drive'	=> 'Google Drive',
            //'onedrive'	=> 'Microsoft OneDrive',
            'twitter'	=> 'Twitter <strong class="gg_disc_source_label">(discontinued)</strong>',
            'tumblr'	=> esc_html__('Tumblr Blog', 'gg_ml'),
            'rml'		=> 'Real Media Library',
            'ngg'		=> 'nextGEN Gallery',
            'rss'		=> esc_html__('RSS Feed', 'gg_ml'),
        );

        /*** remove sources if PHP version is old ***/
        $php_ver = (float)substr(PHP_VERSION, 0, 3);

        if($php_ver < 8.0) {unset($types['g_drive']);}	
        if($php_ver < 5.6) {unset($types['onedrive']);}	

        return (empty($type)) ? $types : $types[$type];
    }
    
    
    
    // gallery data compress and save
    public static function save_data($gid, $data, $autopop = false, $wp_gall_hash = '') {
        if(!is_array($data)) {
            return false;    
        }
        
        $str = serialize($data);
        if(function_exists('gzcompress') && function_exists('gzuncompress')) {
            $str = gzcompress($str, 9);
        }
        $str = base64_encode($str);

        if($autopop){
            update_post_meta($gid, 'gg_autopop_cache', $str); 
        } else {
            update_post_meta($gid, 'gg_gallery'.$wp_gall_hash, $str); 
        }


        // GG v6 - save also utility meta
        if(empty($wp_gall_hash)) {
            update_post_meta($gid, 'gg_img_count', count($data)); // images count

            // first 4 images (URL + thumb center)
            $first_imgs_data = array();		
            for($a=0; $a<4; $a++) {

                if(isset($data[$a])) {
                    $first_imgs_data[] = array(
                        'img_src'	=> $data[$a]['img_src'],
                        'thumb' 	=> (isset($data[$a]['thumb'])) ? $data[$a]['thumb'] : 'c',
                    );
                }
            }
            update_post_meta($gid, 'gg_first_imgs_data', $first_imgs_data);
        }
        return true;
    }


    
    // gallery data uncompress and get 
    public static function get_data($gid, $autopop = NULL, $wp_gall_hash = '') {
        if(get_post_status($gid) != 'publish') {
            return false;    
        }
        
        // autopop or not? (if not already specified)
        if($autopop === NULL) {
            $autopop = get_post_meta($gid, 'gg_autopop', true);	
        }

        $data = (!$autopop) ? get_post_meta($gid, 'gg_gallery'.$wp_gall_hash, true) : get_post_meta($gid, 'gg_autopop_cache', true);

        if(!is_array($data) && !empty($data)) {
            $string = base64_decode($data);
            if(function_exists('gzcompress') && function_exists('gzuncompress') && !empty($string)) {
                $string = gzuncompress($string);
            }
            $data = (array)unserialize($string);
        }

        if(!is_array($data) || (count($data) == 1 && !$data[0])) {
            $data = false;
        }
        return $data;
    }
    
    
    
    // get gallery value and, where needed, recall global value
    public static function check_default_val($gid, $key, $default = '', $prior_value = false) {
        $specific_val = get_post_meta($gid, $key, true);

        // if has to check another value (eg. specific gallery layout to determine specific sizes)
        if($prior_value !== false) {
            if((empty($prior_value) || $prior_value == 'default') && $prior_value !== '0') {
                $specific_val = false;	
            }
        }

        return ((empty($specific_val) || $specific_val == 'default') && $specific_val !== '0') ? get_option($key, $default) : $specific_val;
    }
    
    
    
    // username field label depending on the type
    public static function username_label($type) {
        switch($type) {
            case 'flickr': 		return __('Set / Profile / Tag URL', 'gg_ml'); break; 
            case 'pinterest': 	return __('Board URL', 'gg_ml'); break;
            case 'instagram':	return __('Profile URL', 'gg_ml'); break;
            case 'twitter':		return __('@Username or #hashtag', 'gg_ml'); break;
            case 'tumblr':		return __('Blog URL', 'gg_ml'); break;
            case 'rss':			return __('Feed URL', 'gg_ml'); break;
            default: 			return __('Username', 'gg_ml'); break;	
        }
    }
    
    
    // cache intervals
    public static function cache_intervals($val = false) {
        $intvals = array(
            '1' 	=> __('1 Hour', 'gg_ml'),
            '2' 	=> __('2 Hours', 'gg_ml'),
            '6'		=> __('6 Hours', 'gg_ml'),
            '12'	=> __('12 Hours', 'gg_ml'),
            '24'	=> __('1 Day', 'gg_ml'),
            '72'	=> __('3 Days', 'gg_ml'),
            '168'	=> __('One week', 'gg_ml'), 
            'none'	=> __('Never', 'gg_ml')
        );

        // GG-FILTER - allow extra gallery cache intervals
        $intvals = apply_filters('gg_gall_cache_intvals', $intvals);
        
        if($val === false) {
            return $intvals;
        }
        else {
            return (isset($intvals[$val])) ? $intvals[$val] : false;
        }	
    }
    
    
    
    // get Flickr subject from given url
    public static function flickr_subj($url) {
        if(strpos($url, "flickr.com") === false) {return false;}	

        if		(strpos($url, "/sets/") !== false || strpos($url, "/albums/") !== false) {return 'set';}
        else if (strpos($url, "/tags/") !== false) {return 'tag';}
        else if (strpos($url, "/photos/") !== false) {return 'photostream';}
        else {return false;}
    }
    
    
    
    // manual gallery - single image code (with placeholders to be replaced)
    public static function manual_image_code_block($sel_link_opt = '', $link_val = '') {
        return '
        <li data-id="%%IMG_ID%%">
            <div class="dashicons dashicons-move gg_sm_handler"></div>
            <div class="gg_cmd_bar">
                <div class="dashicons dashicons-saved gg_row_to_sel" title="'. esc_attr__('select image', 'gg_ml') .'"></div>
                <div class="dashicons dashicons-no-alt gg_del_row" title="'. esc_attr__('remove image', 'gg_ml') .'"></div>
                <div class="dashicons dashicons-image-crop gg_sel_thumb" title="'. esc_attr__("set thumbnail's center", 'gg_ml') .'">
                    <input type="hidden" name="gg_item_thumb[]" value="%%THUMB_CENTER%%" class="gg_item_thumb" />
                </div>
                <div class="dashicons dashicons-external gg_enlarge_img" title="'. esc_attr__('enlarge image', 'gg_ml') .'"></div>
            </div>
            <div class="gg_builder_img_wrap">
                <figure style="background-image: url(%%THUMB-URL%%);" class="gg_builder_img" data-fullurl="%%FULL-URL%%" title="'. __("click to enlarge", 'gg_ml') .'"></figure>
                <input type="hidden" name="gg_item_img_src[]" value="%%IMG_SRC%%" class="gg_item_img_src" />
            </div>
            <div class="gg_img_texts">
                <table>
                  <tr>
                    <td class="gg_img_data_icon"><span class="dashicons dashicons-admin-users" title="'. esc_attr__('photo author', 'gg_ml') .'"></span></td>
                    <td><input type="text" name="gg_item_author[]" value="%%AUTHOR%%" class="gg_item_author" autocomplete="off" /></td>
                  </tr>
                  <tr>
                    <td class="gg_img_data_icon"><span class="dashicons dashicons-editor-textcolor" title="'. esc_attr__('photo title', 'gg_ml') .'"></span></td>
                    <td><textarea name="gg_item_title[]" class="gg_item_title" autocomplete="off">%%TITLE%%</textarea></td>
                  </tr>
                  <tr>
                    <td class="gg_img_data_icon"><span class="dashicons dashicons-editor-alignleft" title="'. esc_attr__('photo description', 'gg_ml') .'"></span></td>
                    <td><textarea name="gg_item_descr[]" class="gg_item_descr" autocomplete="off">%%DESCR%%</textarea></td>
                  </tr>
                  <tr>
                    <td class="gg_img_data_icon"><span class="dashicons dashicons-tag" title="'. esc_attr__('photo tags - comma split', 'gg_ml') .'"></span></td>
                    <td><textarea name="gg_item_tags[]" class="gg_item_tags" autocomplete="off">%%TAGS%%</textarea></td>
                  </tr>
                  <tr>
                    <td class="gg_img_data_icon"><span class="dashicons dashicons-admin-links" title="'. esc_attr__('photo link', 'gg_ml') .'"></span></td>
                    <td>
                        <select name="gg_link_opt[]" class="gg_linking_dd" autocomplete="off">
                            <option value="none">'. __('No link', 'gg_ml') .'</option>
                            <option value="page" '. selected($sel_link_opt, 'page', false) .'>'. esc_html__('To a page', 'gg_ml') .'</option>
                            <option value="custom" '. selected($sel_link_opt, 'custom', false) .'>'. esc_html__('Custom link', 'gg_ml') .'</option>
                        </select>
                        <div class="gg_link_wrap">'.gg_static::link_field($sel_link_opt, $link_val).'</div>
                    </td>
                  </tr>
                </table>
            </div>
        </li>';
    }
    
    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    
    

    // get custom post types and taxonomies
    public static function get_cpt_with_tax() {
        $cpt = get_post_types(array('_builtin' => false), 'objects');
        $usable = array(); 

        foreach($cpt as $pt) {
            $tax = get_object_taxonomies($pt->name, 'objects');

            // add only if has a taxonomy
            if(is_array($tax) && !empty($tax)) {
                $tax_array = array();

                foreach($tax as $slug => $data) {
                    $tax_array[$slug] = $data->labels->name;	
                }

                $usable[ $pt->name ] = array(
                    'name' => $pt->labels->name,
                    'tax' => $tax_array
                );		
            }
        }

        return (empty($usable)) ? array() : $usable;
    }

    

    // given cpt + taxonomy - get taxonomy terms in a select field
    public static function get_taxonomy_terms($cpt_tax, $sel_val = '') {
        $arr = explode('|||', $cpt_tax);
        $cats = get_terms($arr[1], 'orderby=name&hide_empty=0');

        $code = '
        <select name="gg_cpt_tax_term" id="gg_cpt_tax_term">
            <option value="">'. __('all', 'gg_ml') .'</option>';

            if(is_array($cats)) {
                foreach($cats as $cat ) {
                    $sel =  ($cat->term_id == $sel_val) ? 'selected="selected"' : '';
                    $code .= '<option value="'.$cat->term_id.'" '.$sel.'>'.$cat->name.'</option>'; 
                }
            }

        return $code . '</select>'; 
    }


    
    // get nextGEN galleries
    public static function get_ngg_galleries($gid = false) {
        global $wpdb;
        $table_name = $wpdb->prefix . "ngg_gallery";	

        // check table existing
        if($wpdb->get_var("SHOW TABLES LIKE '". $table_name ."'") != $table_name) {
            die( __('nextGEN gallery plugin seems missing. No trace in the database', 'gg_ml') );	
        }

        // specific gallery path condition
        $search = ($gid) ? 'WHERE gid = '. (int)$gid : '';
        $query = $wpdb->get_results("SELECT gid, title, path FROM ". $table_name ." ".$search, ARRAY_A);

        if($gid) {
            // clean base to be usable with WP constants
            $base = $query[0]['path'];

            if(substr($base, 0, 1) == DIRECTORY_SEPARATOR) {$base = substr($base, 1);}
            $base = explode(DIRECTORY_SEPARATOR, $base);
            unset($base[0]);

            return implode(DIRECTORY_SEPARATOR, $base);	
        } else {
            return $query;	
        }
    }



    // get Real Media Library folders
    public static function get_rml_galleries($parent_obj = false, $pre_name = '') {

        // check table existing
        if(!defined('RML_FILE')) {
            die( __('Real Media Library plugin must be enabled to use it as source', 'gg_ml') );	
        }

        $folders 	= array();
        $obj 		= ($parent_obj) ? $parent_obj->getChildren() : wp_rml_root_childs(); 
        $pre_name	.= ($parent_obj) ? '-' : '';

        foreach($obj as $folder) {
            $folders[ $folder->getId() ] = $pre_name .' '. $folder->getName();

            // check for childrens
            $childs = self::get_rml_galleries($folder, $pre_name);

            if(!empty($childs)) {
                $folders += $childs;	
            }	
        }

        return $folders;
    }

    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    

    
    // update auto-population cache
    public static function autopop_update_cache($gid, $manual_attr = array()) {
        include_once(GG_DIR . '/classes/gg_img_fetcher.php');

        $type 		= (empty($manual_attr)) ? get_post_meta($gid, 'gg_type', true) : $manual_attr['type'];
        $o_max_img 	= (empty($manual_attr)) ? get_post_meta($gid, 'gg_max_images', true) : $manual_attr['max_images'];
        $max_img 	= (empty($manual_attr)) ? get_post_meta($gid, 'gg_max_images', true) : $manual_attr['max_images'];
        $random 	= (empty($manual_attr)) ? get_post_meta($gid, 'gg_auto_random', true) : $manual_attr['random'];

        // extra data
        if(empty($manual_attr)) {
            switch($type) {
                case 'wp_cat'	: $extra = get_post_meta($gid, 'gg_wp_cat', true); 	break;
                case 'cpt_tax'	: $extra = array('cpt_tax' => get_post_meta($gid, 'gg_cpt_tax', true), 'term' => get_post_meta($gid, 'gg_cpt_tax_term', true)); 	break;
                case 'gg_album'	: $extra = get_post_meta($gid, 'gg_album', true); 	break;
                case 'g_drive'	: $extra = get_post_meta($gid, 'gg_gdrive_album', true); break;
                case 'onedrive'	: $extra = get_post_meta($gid, 'gg_onedrive_album', true); break;
                case 'rml'		: $extra = get_post_meta($gid, 'gg_rml_folder', true); break;
                case 'ngg'		: $extra = get_post_meta($gid, 'gg_ngg_gallery', true); break;
                default			: $extra = ''; break; 	
            }
        }
        else {$extra = $manual_attr['extra'];}

        // images fetcher 
        $fetcher = new gg_img_fetcher($gid, $type, $page = 1, $o_max_img, '', $extra);
        $img_data = $fetcher->get;

        if(!empty($fetcher->errors)) {
            trigger_error(implode(' | ', $fetcher->errors));
            return self::get_data($gid, true);
        }
        
        $images = $img_data['img'];
        if($max_img >= count($images)) {$max_img = count($images);}

        if($random == '1') { 
            shuffle($images);

            $to_display = array();
            for($a=0; $a < $max_img; $a++) {
                $to_display[]	= $images[$a];
            }
        }
        else {
            $to_display = array();
            for($a=0; $a < $max_img; $a++) {
                if(isset($images[$a])) { $to_display[] = $images[$a]; }
            }
        }

        $to_save = array();
        foreach($to_display as $img) {
            if(in_array($type, array('wp', 'wp_cat', 'rml'))) {
                $img_src = $img['id'];
            } 
            elseif($type == 'gg_album' || $type == 'ngg') {
                $img_src = $img['path'];
            }
            else {
                $img_src = $img['url'];
            }

            $to_add = array( 
                'url' 		=> $img['url'],
                'img_src'	=> $img_src,
                'author'	=> $img['author'],
                'title'		=> $img['title'],
                'descr'		=> $img['descr']
            );	

            if($type == 'gg_album' && isset($img['tags'])) {
                $to_add['tags'] = $img['tags'];
            }

            if(($type == 'wp_cat' || $type == 'cpt_tax') && isset($img['link'])) {
                $to_add['link_opt'] = 'custom';
                $to_add['link'] = $img['link'];
            }

            $to_save[] = $to_add;	
        }

        // if the maximum number is not reached, try to add the old images - only if erase past if false
        if(empty($manual_attr) || !$manual_attr['erase_past']) {
            if(count($to_save) < $o_max_img) {
                $old_img = self::get_data($gid, true);
                if(is_array($old_img)) {

                    $a = 0;
                    while($o_max_img > count($to_save) && isset($old_img[$a]))	 {
                        $exists = false;
                        foreach($to_save as $img) {
                            if($old_img[$a]['img_src'] == $img['img_src']) {$exists = true;}
                        }

                        if(!$exists) {$to_save[] = $old_img[$a];}

                        $a++;	
                    }
                }
            }
        }

        // save the autopop cache
        self::save_data($gid, $to_save, true);

        // save creation time
        update_post_meta($gid, 'gg_autopop_time', current_time('timestamp'));

        return $to_save;
    }



    // check autopop creation time - if outdated refetch - and return the images array
    public static function autopop_expir_check($gid) {
        $last_update        = (int)get_post_meta($gid, 'gg_autopop_time', true);
        $update_interval    = (float)get_post_meta($gid, 'gg_cache_interval', true) * 60 * 60;
        $timestamp          = (int)current_time('timestamp');

        if($update_interval && $update_interval != 'none' && ($timestamp - $last_update) >= $update_interval) {
            $images = self::autopop_update_cache($gid);
        }
        else {
            $images = self::get_data($gid, true);
        }

        return $images;
    }


    
    // returns gallery images applying custom sortings
    public static function sort_images($images, $key = 'title', $order = 'asc') {

        // set key as image array index
        $arr = array();
        foreach($images as $id => $data) {
            $arr[ strtolower($data[$key]) ] = $data;	
        }

        // sort
        ksort($arr, SORT_NATURAL);
        if($order == 'desc') {
            $arr = array_reverse($arr);
        }

        return array_values($arr);
    }
    
    

    // returns image array ready to be used in frontend - checks autopopulation cache
    public static function frontend_img_prepare($gid, $type, $wp_gall_hash = false) {
        $autopop = get_post_meta($gid, 'gg_autopop', true);

        // manual - autopop switch
        $checked = ($autopop) ? self::autopop_expir_check($gid) : self::get_data($gid, false, $wp_gall_hash);

        // sorting system
        if(!$wp_gall_hash) {
            $sorting = get_post_meta($gid, 'gg_orderby', true); 

            if(
                empty($checked) || !$sorting || $sorting == 'default' || 
                (strpos($sorting, 'id_') !== false && !in_array($type, array('wp', 'wp_cat', 'cpt_tax', 'rml'))) // ID sorting only for WP images
            ) {
                $checked = $checked; // do nothing
            }

            else {
                $sort_params = explode('_', $sorting);

                if($sort_params[0] == 'id') { // WP id is just the img_src
                    $sort_params[0] = 'img_src';
                }

                $checked = self::sort_images($checked, $sort_params[0], $sort_params[1]);
            }
        }
        
        
        // GG-FILTER - allows extra control over prepared gallery images - passes gallery ID and type
        $checked = apply_filters('gg_img_prepare', $checked, $gid, $type);
        
        return $checked;
    }
    
    
    
    //// given the final image array - returns a part of them basing on their keys and applies watermark
    // selection array -> (index start, images number to fetch)
    public static function frontend_img_split($gid, $images, $selection = 'all', $randomized_order = false, $watermark = false) {
        $to_return = array();
        $apply_watermark = ($watermark && filter_var(get_option('gg_watermark_img'), FILTER_VALIDATE_URL)) ? true : false;

        // if no randomized order - setup an array with increasing values
        if(!$randomized_order) {
            $randomized_order = array();

            foreach($images as $img_id => $img_data) {
                $randomized_order[] = $img_id;	
            }
        }
        $start = (is_array($selection)) ? $selection[0] : 0;
        $end = (is_array($selection)) ? $selection[1] : count($images);
        
        if(!isset($randomized_order[$start])) {
            return $images;
        }


        // no gg gallery post type - is a WP gallery
        if(get_post_type($gid) != 'gg_galleries') {
            $type 			= 'wp';
            $autopop 		= false;
            $show_authors 	= false;
            $show_titles 	= false;
            $show_descr 	= false;	
            $auto_link 		= false;		
        }
        else {
            $type 			= get_post_meta($gid, 'gg_type', true);
            $autopop 		= get_post_meta($gid, 'gg_autopop', true);
            
            $forced_author 	= (!$autopop) ? false : get_post_meta($gid, 'gg_forced_author', true);
            $show_authors 	= (!$autopop) ? false : get_post_meta($gid, 'gg_auto_author', true);
            $show_titles 	= (!$autopop) ? false : get_post_meta($gid, 'gg_auto_title', true);
            $show_descr 	= (!$autopop) ? false : get_post_meta($gid, 'gg_auto_descr', true);	
            $auto_link 		= (!$autopop) ? false : get_post_meta($gid, 'gg_auto_link', true);	
        }

        for($a=$start; $a<$end; $a++) {
            if(!isset($randomized_order[$a])) { // NOTE: if no radomized - the $randomized_order contains increasing values
                break;
            } 
            $img_index = $randomized_order[$a];

            if(!isset($images[$img_index])) {
                break;
            }
            $img = $images[$img_index];	


            // apply watermark	
            if($apply_watermark) {
                $full_src = gg_static::img_src_on_type($img['img_src'], $type);
                $new_paths = gg_static::watermark_image($full_src);

                $img['wm_url']  = (is_array($new_paths)) ? $new_paths['url'] : '';
                $img['wm_path'] = (is_array($new_paths)) ? $new_paths['path'] : '';
            }


            // prepare image's array
            if($autopop) {
                if($forced_author) {
                    $img['author'] = $forced_author;  
                }
                
                if(!$show_titles) 	{$img['title'] = '';}
                if(!$show_authors) 	{$img['author'] = '';}
                if(!$show_descr) 	{$img['descr'] = '';}  
                if(!$auto_link)		{$img['link'] = '';}  

                $img['thumb'] = 'c';	
            }

            if(isset($img['wm_path'])) {
                $img['path'] = (get_option('gg_use_url_for_wp_thumbs')) ? $img['wm_url'] : $img['wm_path'];
                $img['url'] =  $img['wm_url'];
            }
            else {
                $img['path'] = gg_static::img_src_on_type($img['img_src'], $type);
                $img['url'] = gg_static::img_url_on_type($img['img_src'], $type);
            }

            // GG-FILTER - allows extra control over final image data array used to populate frontend galleries
            $to_return[$img_index] = apply_filters('gg_final_img_data', $img, $gid, $apply_watermark);
        }
        return $to_return;	
    }
    
    
    
    
    ///////////////////////////////////////////////////////////////////////////////////////////////////
    
    

    
    // given the images array, returns a multidimensional array('tag' => array(img_indexes)) containing tags and associated images
    public static function get_gallery_tags($images) {
        $tags = array();

        foreach($images as $img_index => $img) {
            if(!isset($img['tags']) || empty($img['tags'])) {continue;}

            $img_tags = explode(',', $img['tags']);
            foreach($img_tags as $tag) {
                $tag = trim($tag);

                if(isset($tags[$tag])) {
                    $tags[$tag][] = $img_index;
                } else {
                    $tags[$tag] = array($img_index);	
                }
            }
        }

        return $tags;
    }



    // given gallery tags array, returns filters code
    public static function gallery_tags_code($uniqid, $gid, $tags, $selected = '') {
        $code = '';

        $tags_treshold 	= (int)get_option('gg_discard_tags', 1);
        $tags_sorting 	= get_option('gg_tags_sort', 'name');
        $show_counter 	= get_option('gg_show_tags_counter');

        $all_txt 		= get_option('gg_tags_all_txt');
        if(empty($all_txt)) {$all_txt = __('All', 'gg_ml');}


        // strip tags with only one attached image?
        if($tags_treshold > 1) {
            foreach($tags as $tag => $img_indexes) {
                if(count($img_indexes) < $tags_treshold) {
                    unset($tags[$tag]);	
                }
            }
            if(empty($tags)) {return '';}
        }


        // tags sorting
        if($tags_sorting == 'name') {
            ksort($tags); 	
        } else {
            asort($tags);	
            $tags = array_reverse($tags);
        }


        $filter_type 	= (get_option('gg_use_old_filters')) ? 'gg_textual_filters' : 'gg_btn_filters';
        $separator 		= (get_option('gg_use_old_filters')) ?'<span>'. get_option('gg_os_filters_separator', '/') .'</span>' : '';
        $all_selected 	= empty($selected) ? 'gg_tag_sel' : ''; 

        $code .= '
        <div class="gg_tags_wrap gg_tag_gid_'. $gid .' '. $filter_type .'" data-gid="'. $uniqid .'">
            <div class="gg_tag '. $all_selected .'"  data-tag="*">'. $all_txt .'</div>';

            foreach($tags as $tag => $img_indexes) {
                $counter 		= ($show_counter) ? '<span class="gg_tag_counter">'. count($img_indexes) .'</span>' : '';
                $selected_class = ($tag == $selected) ? 'gg_tag_sel' : '';   

                $code .= $separator .
                '<div class="gg_tag '. $selected_class .'" data-gid="'. $uniqid .'" data-tag="'. esc_attr(urlencode($tag)) .'" data-images="'. implode(',', $img_indexes) .'">'.
                    $tag . $counter .
                '</div>';	
            }


            // needs also dropdown?
            if(get_option('gg_dd_mobile_filter')) {
                $code .= '
                <label for="gg_tags" class="gg_displaynone">tags</label>
                <select name="gg_tags" class="gg_mobile_filter_dd gg_tags_dd" autocomplete="off">
                    <option value="*">'. $all_txt .'</option>';	

                    foreach($tags as $tag => $img_indexes) {
                        $counter = ($show_counter) ? ' '. count($img_indexes) : ''; 
                        $code .= '<option value="'. esc_attr(urlencode($tag)) .'" '. selected($tag, $selected, false) .'>'. $tag . $counter .'</option>';	
                    }

                $code .= '
                </select>';	
            }

        return $code .'</div>'; 
    }
    
    
    
    // Jan 2024 - Google Drive URL blocks background image usage - use the thumb trick
    public static function gdrive_img_url_trick($img_url) {
        if(strpos($img_url, 'drive.google.com') === false || strpos($img_url, 'drive.google.com/thumbnail') !== false) {
            return $img_url;   
        }
        
        $url_components = parse_url($img_url);
        parse_str($url_components['query'], $params);
        
        if(is_array($params) && isset($params['id'])) {
            $img_url = 'https://drive.google.com/thumbnail?sz=w5000&id='. $params['id'];
        }

        return $img_url;    
    }
}
