<?php
// STATIC METHODS RELATED TO COLLECTIONS
class gg_coll_static {

    
    // single gallery code for collection's builder (with placeholders to be replaced)
    public static function manual_gall_code_block($link_opt = '', $link_val = '') {
        return '
        <tr class="coll_component" data-id="%%GALL_ID%%">
            <td class="gg_coll_gall_imgbox" style="background-image: url(\'%%THUMB_TO_USE%%\');">

                <div class="dashicons dashicons-no-alt gg_del_row gg_del_gall"></div>
                <div class="dashicons dashicons-leftright gg_move_row"></div>

                <div class="gg_coll_cust_img_btn %%CUST-ICON_SEL_CLASS%%" title="'. esc_attr__('Manage custom main image', 'gg_ml') .'">
                    <span class="dashicons dashicons-camera-alt"></span>
                    <input type="hidden" name="gg_coll_cust_img" value="%%CUST_IMG_ID%%" class="gg_coll_cust_img" />

                    <div class="gg_coll_del_cust_img_btn" title="'. esc_attr__('Remove custom main image', 'gg_ml') .'" orig-img="%%ORIG_THUMB%%">
                        <span class="dashicons dashicons-camera-alt"></span>
                    </div>
                </div>

                <div class="gg_coll_gall_cats">
                    <span>%%GALL_CATS%%</span>
                </div>
            </td>
            <td class="gg_coll_gall_inner">
                <h2>
                    <a href="'. get_admin_url() .'post.php?post=%%GALL_ID%%&action=edit" target="_blank" title="'. esc_attr__('edit gallery', 'gg_ml').'">%%GALL_TITLE%%</a>
                </h2>

                <div class="gg_coll_gall_switches">
                    <div>
                        <label>'. __('Random display?', 'gg_ml') .'</label>
                        <input type="checkbox" name="random" class="gg_lc_switch" value="1" %%RANDOM_CHECK%% autocomplete="off" />
                    </div>
                    <div>
                        <label>'. __('Use tags filter?', 'gg_ml') .'</label>
                        <input type="checkbox" name="tags_filter" class="gg_lc_switch" value="1" %%FILTER_CHECK%% autocomplete="off" />
                    </div>
                    <div>
                        <label>'. __('Search Box?', 'gg_ml') .'</label>
                        <input type="checkbox" name="search" class="gg_lc_switch" value="1" %%SEARCH_CHECK%% autocomplete="off" />
                    </div>
                    <div>
                        <label>'. __('Use watermark?', 'gg_ml') .'</label>
                        <input type="checkbox" name="watermark" class="gg_lc_switch" value="1" %%WATERM_CHECK%% autocomplete="off" />
                    </div>
                </div>    

                <div class="gg_coll_gall_link">
                    <select name="gg_linking_dd" class="gg_linking_dd">
                        <option value="none">'. __('No link', 'gg_ml') .'</option>
                        <option value="page" '. selected($link_opt, 'page', false) .'>'. __('To a page', 'gg_ml') .'</option>
                        <option value="custom" '. selected($link_opt, 'custom', false) .'>'. __('Custom link', 'gg_ml') .'</option>
                    </select>
                    <div class="gg_link_wrap">'. gg_static::link_field($link_opt, $link_val) .'</div>
                </div>

                <textarea name="coll_descr" class="coll_descr" placeholder="'. esc_attr__('Gallery description - supports %IMG-NUM% placeholder', 'gg_ml') .'" autocomplete="off">%%DESCR%%</textarea>
            </td>
          </tr>';
    }
    
    
    
    // giving a gallery ID returns the associated categories
    public static function gallery_cats($gid, $return = 'list', $list_divider = ', ') {
        $terms = wp_get_post_terms($gid, 'gg_gall_categories');	

        if(count($terms) == 0) {
            return ($return == 'list') ? '' : array();	
        }

        $to_return = array();
        foreach($terms as $term) {
            // WPML fix - get original ID
            if (function_exists('icl_object_id')) {
                global $sitepress;
                $term_id = icl_object_id($term->term_id, 'gg_gall_categories', true);
                $term = get_term($term_id, 'gg_gall_categories');
            }

            if($return == 'list') {$to_return[] = $term->name;}
            elseif($return == 'class_list') {$to_return[] = 'ggc_'.$term->term_id;}
            else {$to_return[] = $term->term_id;}	
        }

        if($return == 'list') {
            return implode($list_divider, $to_return);
        }
        elseif($return == 'class_list') {
            return implode(' ', $to_return);
        }
        else {
            return $to_return;
        }	
    }

    

    // get the gallery first image
    public static function get_gall_first_img($gid, $return = 'img') {

        $first_imgs = (array)get_post_meta($gid, 'gg_first_imgs_data', true);		
        if(!count($first_imgs) || !isset($first_imgs[0]['img_src'])) {
            return false;
        } 

        $type = get_post_meta($gid, 'gg_type', true);
        $img_src = gg_static::img_src_on_type($first_imgs[0]['img_src'], $type);

        if($return == 'img') {return $img_src;}
        else {
            return array(
                'src' 	=> $img_src,
                'align' => $first_imgs[0]['thumb']
            );		
        }
    }

    

    // giving a category, return the associated galleries (for collection builder)
    public static function cat_galleries($cat) {
        if(!$cat) {return false;}

        $args = array(
            'posts_per_page'  => -1,
            'post_type'       => 'gg_galleries',
            'post_status'     => 'publish'
        );

        if($cat != 'all') {
            $term_data = get_term_by( 'id', $cat, 'gg_gall_categories');	
            $args['gg_gall_categories'] = $term_data->slug;		
        }	
        $raw_galleries = get_posts($args);

        $galleries = array();
        foreach($raw_galleries as $gallery) {
            $gid = $gallery->ID;
            $img = self::get_gall_first_img($gid);

            if($img) { 
                $galleries[] = array(  
                    'id' =>	$gid,
                    'title' => $gallery->post_title,
                    'img' => $img,
                    'cats' => self::gallery_cats($gid)
                );
            }
        }


        if(count($galleries) > 0) {  
            return $galleries;
        } else { 
            return false; 
        }
    }
    
    
    
    // return the collections filter code
    public static function coll_filter_code($terms, $return = 'html', $sel_val = '', $hide_all = false) {
        if(!$terms) {
            return false;
        }

        // sort terms
        $ordered = array();
        foreach($terms as $term_id) {
            $ord = (int)get_option("gg_cat_".$term_id."_order");

            // check the final order
            while( isset($ordered[$ord]) ) {
                $ord++;	
            }

            $ordered[$ord] = $term_id;
        }
        ksort($ordered, SORT_NUMERIC);

        $terms = $ordered;
        $terms_data = array();

        $a = 0;
        foreach($terms as $term) {
            $term_data = get_term_by('id', $term, 'gg_gall_categories');

            if(is_object($term_data)) {
                $icon = gg_static::retrocomp_get_term_meta($term_data->term_id, 'gg_cat_icon', "gg_cat_". $term_data->term_id ."_icon");
                $icon = (!empty($icon)) ? '<i class="mg_cat_icon '. esc_attr(gg_static::fontawesome_v4_retrocomp($icon)) .'"></i>' : ''; 

                $terms_data[$a] = array('id' => $term, 'name' => $term_data->name, 'slug' => $term_data->slug, 'icon' => $icon); 		
                $a++;
            }
        }


        // "ALL" text
        if(!$hide_all) {
            $all_txt = get_option('gg_filters_all_txt');
            if(empty($all_txt)) {
                $all_txt = __('All', 'gg_ml');
            }
        }


        if($return == 'html') {
            $all_sel_class 		= (!$sel_val) ? 'gg_cats_selected' : '';  
            $coll_terms_list 	= ($hide_all) ? '' : '<a class="ggf ggf_all '. $all_sel_class .'" data-coll-filter-id="*" href="javascript:void(0)">'. $all_txt .'</a>';
            $separator 			= (get_option('gg_use_old_filters')) ? '<span>'. get_option('gg_os_filters_separator', '/') .'</span>' : '';

            foreach($terms_data as $term) {
                $sel_class 		= ($term['id'] == $sel_val) ? 'gg_cats_selected' : '';  

                $coll_terms_list .= $separator .
                '<a class="ggf_id_'.$term['id'].' ggf '. $sel_class .'" data-coll-filter-id="'.$term['id'].'" href="javascript:void(0)">'.$term['icon'] . $term['name'].'</a>';	
            }

            return $coll_terms_list;
        }

        elseif($return == 'dropdown') {
            $code = '
            <select class="gg_mobile_filter_dd" autocomplete="off">';
            
                if(!$hide_all) {
                    $code .= '<option value="*">'. $all_txt .'</option>';	
                }
                    
                foreach($terms_data as $term) { 
                    $code .= '<option value="'.$term['id'].'" '. selected($sel_val, $term['id'], false) .'>'.$term['name'].'</option>';	
                }

            return $code . '
            </select>';	
        }
    }
    
    
}
