<?php
// REGISTER GRID BLOCK
include_once(GG_DIR .'/settings/field_options.php');



// collections array (use full list for now)
$collections = get_terms('gg_collections', 'hide_empty=0');

$colls = array(); 
foreach($collections as $collection) {
	$colls[ $collection->term_id ] = $collection->name;
}


// collection filters array
$filters = array(
    '' => '('. esc_html__('none', 'gg_ml') .')'
); 
foreach(get_terms('gg_gall_categories', 'hide_empty=0') as $cat) {
	$filters[ $cat->term_id ] = $cat->name;
}



/////////////////////////////////////////////



// structure
$defaults = array(
	'cid' => array(
		'label'		=> __('Which collection?', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array('' => __('Select a collection', 'gg_ml')) + $colls,
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'random' => array(
		'label'		=> __('Random display?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
    
    'filter' => array(
		'label'		=> __('Use tags filter?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
	),
    'def_filter' => array(
		'label'		=> __('Selected filter', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> $filters,
		'default' 	=> '',
		'panel'		=> 'main',
        
        'condition' => array(
			'filter' => array(
				'!=', 
				array('', false, 0)
			)
		)
	),
    'hide_all_filter' => array(
		'label'		=> __('Hide "All" filter?', 'gg_ml'),
		'type'		=> 'checkbox',
		'default' 	=> '',
		'panel'		=> 'main',
        
        'condition' => array(
			'filter' => array(
				'!=', 
				array('', false, 0)
			)
		)
	),
    
	'pag_sys' => array(
		'label'		=> __('Pagination system', 'gg_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'' 		=> __('None', 'gg_ml'),
			'auto' 	=> __('Auto - follow global settings', 'gg_ml')
			) + gg_pag_sys(),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'per_page' => array(
		'label'		=> __('How many galleries per page?', 'gg_ml'),
		'type'		=> 'slider',
		'min'		=> 0,
		'max'		=> 200,
		'default' 	=> 0,
		'panel'		=> 'main',
		
		'condition' => array(
			'pag_sys' => array(
				'!=', 
				array('')
			)
		)
	),
);




$defaults = gg_fix_block_defs($defaults);

register_block_type('lcweb/g-collection', array(
	'editor_script' 	=> 'gg_coll_on_guten',
	'render_callback' 	=> 'gg_collection_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'gg_coll_defaults', $defaults);
