<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class gg_carousel_divi_module extends ET_Builder_Module {

	public $slug       = 'gg_carousel';
	public $vb_support = 'off';

    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/global-gallery',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'GG - '. esc_html__('Carousel', 'gg_ml');
		$this->icon_path          =  $GLOBALS['gg_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', 'gg_ml'),
					'styling'  => esc_html__('Styling', 'gg_ml'),
				),
			),
		);
	}
 
    
	public function get_fields() {
        $fields =array(
            'gid' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Images source', 'gg_ml'),
				'type'            => 'select',
                'default'         => current(array_keys($GLOBALS['gg_divi_galls'])),
				'default_on_front'=> current(array_keys($GLOBALS['gg_divi_galls'])),
				'options'         => $GLOBALS['gg_divi_galls'],
				//'description'     => esc_html__( 'Choose whether your linklink opens in a new window or not', 'dicm-divi-custom-modules' ),
			),
            'img_max_w' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Images max width", 'gg_ml'),
				'type'            => 'range',
                'default'         => 180,
				'default_on_front'=> 180,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 2000,
                    'step'  => 20
				),
                'validate_unit' => false,
			),
            'lc_height' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Images height", 'gg_ml'),
				'type'            => 'range',
                'default'         => 200,
				'default_on_front'=> 200,
				'range_settings'    => array(
					'min'   => 20,
					'max'   => 1000,
                    'step'  => 20
				),
                'validate_unit' => false,
			),
            'h_type' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Height's unit type", 'gg_ml'),
				'type'            => 'select',
				'default'         => 'px',
				'default_on_front'=> 'px',					
				'options'         => array(
				    'px'	=> 'px ('. esc_html__("static", 'gg_ml') .')',
                    '%'	=> '% ('. esc_html__("responsive", 'gg_ml') .')',
				),
			),
            'rows' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Rows", 'gg_ml'),
				'type'            => 'range',
                'default'         => 1,
				'default_on_front'=> 1,
				'range_settings'    => array(
					'min'   => 1,
					'max'   => 10,
                    'step'  => 1
				),
                'validate_unit' => false,
                'description'   => esc_html__('Choose how many image rows to use', 'gg_ml'),
			),
            'multiscroll' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Multi-scroll?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
                'description'   => esc_html__('Slides multiple images per time', 'gg_ml'),
			),
            'center' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Center display mode?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),
            'nocrop' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Avoid images crop?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
                'description'   => esc_html__('Just downscales images', 'gg_ml'),
			),
            'static' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Static mode?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
                'description'   => esc_html__('Disables overlay and lightbox', 'gg_ml'),
			),
            'random' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Random display?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'watermark' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Use watermark?', 'gg_ml'),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'autoplay' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Autoplay slider?", 'gg_ml'),
				'type'            => 'select',
				'default'         => 'auto',
				'default_on_front'=> 'auto',					
				'options'         => array(
				    'auto'	=> __('as default', 'gg_ml'),
                    '1'		=> __('Yes'),
                    '0'		=> __('No'),
				),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return gg_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new gg_carousel_divi_module;